//
//  YHHaveGrabbedNumberInfoView.swift
//  galaxy
//
//  Created by edy on 2024/8/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHaveGrabbedNumberInfoView: UIView {
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var markView: UIView = {
        let view = UIView()
        view.backgroundColor = .brandMainColor
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 16)
        label.textColor = .mainTextColor
        return label
    }()
    
    lazy var membersLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.text = "成员："
        label.textColor = .mainTextColor(alpha: 0.7)
        return label
    }()
    
    lazy var grabInfoView: YHGrabNumberInfoView = {
        let view = YHGrabNumberInfoView(frame: .zero)
        view.titleLabel.text = "抢号信息"
        let items = [YHGrabItem(type: .info, title: "赴港时间：", detail: "", isSingleLine: true),
                     YHGrabItem(type: .info, title: "香港办证点：", detail: "", isSingleLine: false),
                     YHGrabItem(type: .files, title: "抢号反馈回执：", detail: "", files: []) ]
        view.updateItems(items)
        return view
    }()
    
    lazy var intentionInfoView: YHGrabNumberInfoView = {
        let view = YHGrabNumberInfoView(frame: .zero)
        view.titleLabel.text = "意向信息"
        let items = [YHGrabItem(type: .info, title: "期望赴港时间：", detail: "", isSingleLine: true),
                     YHGrabItem(type: .info, title: "期望香港办证点：", detail: "", isSingleLine: false)]
        view.updateItems(items)
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        self.addSubview(lineView)
        self.addSubview(markView)
        self.addSubview(titleLabel)
        self.addSubview(membersLabel)
        self.addSubview(grabInfoView)
        self.addSubview(intentionInfoView)
        
        lineView.snp.makeConstraints { make in
            make.top.equalTo(-0.5)
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        markView.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: 3, height: 14))
            make.left.equalTo(0)
            make.centerY.equalTo(titleLabel)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(markView.snp.right).offset(6)
            make.height.equalTo(22)
            make.top.equalTo(lineView.snp.bottom).offset(16)
        }
        
        membersLabel.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
        }
        
        grabInfoView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(membersLabel.snp.bottom).offset(16)
        }
        
        intentionInfoView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(grabInfoView.snp.bottom).offset(16)
            make.bottom.equalTo(0)
        }
    }
}
